<?php
session_start();
require 'config.php';

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Captura o input de login que pode ser nome de usuário ou email
    $login = $_POST['login']; 
    $password = $_POST['password'];

    // Verifica se o login é um email ou um nome de usuário
    if (filter_var($login, FILTER_VALIDATE_EMAIL)) {
        $sql = "SELECT * FROM usuarios WHERE email = ?";
    } else {
        $sql = "SELECT * FROM usuarios WHERE username = ?";
    }
    
    $stmt = $conn->prepare($sql);
    $stmt->execute([$login]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($user && password_verify($password, $user['password'])) {
        $_SESSION['user_id'] = $user['id'];
        header("Location: dashboard.php");
        exit();
    } else {
        $error = "Usuário/email ou senha inválidos.";
    }
}
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Página de Login</title>
    <link rel="stylesheet" href="/css/bootstrap.min.css">
    <style>
        /* CSS personalizado para o formulário */
        body {
            background-color: #f8f9fa;
            font-family: Arial, sans-serif;
        }
        .container {
            max-width: 400px;
            margin-top: 80px;
            background-color: #fff;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
        }
        .form-control {
            margin-bottom: 15px;
            border-radius: 8px;
            padding: 10px;
        }
        .btn-primary {
            background-color: #5cb85c;
            border-color: #5cb85c;
            border-radius: 30px;
            padding: 10px 20px;
            width: 100%;
        }
        .btn-primary:hover {
            background-color: #4cae4c;
        }
        .recover-password {
            display: block;
            margin-top: 10px;
            text-align: center;
            color: #6c757d;
        }
        .recover-password:hover {
            color: #5a6268;
            text-decoration: underline;
        }
        .error {
            color: red;
            text-align: center;
            margin-bottom: 15px;
        }
    </style>
</head>
<body>
    <div class="container">
        <h2 class="text-center">Login</h2>
        <?php if (isset($error)) { echo "<p class='error'>$error</p>"; } ?>
        <form action="" method="POST">
            <input type="text" name="login" class="form-control" placeholder="Usuário ou Email" required> <!-- Campo unificado -->
            <input type="password" name="password" class="form-control" placeholder="Senha" required>
            <button type="submit" class="btn btn-primary">Entrar</button>
        </form>
        <a href="recuperar_senha.php" class="recover-password">Recuperar Senha</a> <!-- Link para recuperar senha -->
    </div>

    <script src="/js/bootstrap.bundle.min.js"></script> <!-- Incluindo o Bootstrap JS -->
</body>
</html>
