<?php
session_start();
require 'config.php'; // Inclua sua configuração de banco de dados aqui

// Inicializa a variável de erro e mensagem de sucesso
$error = '';
$success_message = '';

// Verifica se o token foi passado pela URL
if (isset($_GET['token'])) {
    $token = $_GET['token'];

    // Consulta para verificar se o token é válido e não expirou
    $sql = "SELECT * FROM usuarios WHERE password_reset_token = ? AND password_reset_expires > NOW()";
    $stmt = $conn->prepare($sql);
    $stmt->execute([$token]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    // Se o token for válido
    if ($user) {
        // Se o formulário foi enviado
        if ($_SERVER["REQUEST_METHOD"] == "POST") {
            $new_password = $_POST['new_password'];
            $confirm_password = $_POST['confirm_password'];

            // Verifica se as senhas são iguais
            if ($new_password === $confirm_password) {
                // Hash da nova senha
                $hashed_password = password_hash($new_password, PASSWORD_DEFAULT);

                // Atualiza a senha no banco de dados
                $sql = "UPDATE usuarios SET password = ?, password_reset_token = NULL, password_reset_expires = NULL WHERE id = ?";
                $stmt = $conn->prepare($sql);
                $stmt->execute([$hashed_password, $user['id']]);

                // Exibe a mensagem de sucesso
                $success_message = "Sua senha foi redefinida com sucesso! Você já pode fazer login.";
            } else {
                $error = "As senhas não coincidem.";
            }
        }
    } else {
        // Se o token não for válido ou estiver expirado
        $error = "Este link de redefinição de senha é inválido ou expirou.";
    }
} else {
    $error = "Token de redefinição não fornecido.";
}
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <title>Redefinir Senha</title>
    <link rel="stylesheet" href="/css/bootstrap.min.css">
    <style>
        /* CSS personalizado */
        body {
            background-color: #f8f9fa;
            font-family: Arial, sans-serif;
        }
        .container {
            max-width: 400px;
            margin-top: 80px;
            background-color: #fff;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
        }
        h2 {
            text-align: center;
            margin-bottom: 20px;
        }
        .form-control {
            border-radius: 8px;
            margin-bottom: 15px;
        }
        .btn-primary {
            background-color: #5cb85c;
            border-color: #5cb85c;
            border-radius: 30px;
            padding: 10px 20px;
            width: 100%;
        }
        .btn-primary:hover {
            background-color: #4cae4c;
        }
        .error {
            color: red;
            text-align: center;
            margin-bottom: 15px;
        }
        .alert-success {
            text-align: center;
        }
    </style>
</head>
<body>
    <div class="container">
        <h2>Redefinir Senha</h2>

        <?php if (!empty($error)) { echo "<p class='error'>$error</p>"; } ?>
        <?php if (!empty($success_message)) { echo "<p class='alert alert-success'>$success_message</p>"; } ?>

        <?php if (empty($success_message)): ?>
        <form action="" method="POST">
            <div class="mb-3">
                <label for="new_password">Nova Senha:</label>
                <input type="password" class="form-control" name="new_password" required>
            </div>
            <div class="mb-3">
                <label for="confirm_password">Confirme a Nova Senha:</label>
                <input type="password" class="form-control" name="confirm_password" required>
            </div>
            <button type="submit" class="btn btn-primary">Redefinir Senha</button>
        </form>
        <?php endif; ?>

        <p class="mt-2"><a href="login.php">Voltar para o login</a></p>
    </div>

    <script src="/js/bootstrap.bundle.min.js"></script>
</body>
</html>
