<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Estamos com saudades de você!</title>

    <!-- Bootstrap CSS -->
    <link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css" rel="stylesheet">
    <link href="css/styles.css" rel="stylesheet">

    <style>
        body {
            background-color: #f5f5f5;
            color: #424242;
            font-family: 'Roboto', sans-serif;
        }

        .container {
            margin-top: 100px;
        }

        .card {
            border-radius: 8px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
            padding: 30px;
            text-align: center;
            background-color: white;
        }

        .card h1 {
            color: #6200ea;
            font-size: 28px;
            font-weight: bold;
            margin-bottom: 20px;
        }

        .card p {
            font-size: 18px;
            margin-bottom: 20px;
            color: #555;
        }

        .btn-primary {
            background-color: #6200ea;
            border: none;
            padding: 10px 20px;
            color: #fff;
            border-radius: 50px;
            transition: background-color 0.3s ease;
        }

        .btn-primary:hover {
            background-color: #3700b3;
        }

        .back-link {
            margin-top: 20px;
            display: inline-block;
            font-size: 16px;
            color: #6200ea;
            text-decoration: none;
        }

        .back-link:hover {
            color: #3700b3;
            text-decoration: underline;
        }
    </style>
</head>
<body>

    <div class="container">
        <div class="card">
            <h1>Estamos com saudades de você!</h1>
            <p>Notamos que sua assinatura está pausada no momento, mas estamos sempre por aqui, prontos para recebê-lo(a) de volta quando você desejar.</p>
            <p>Se precisar de qualquer ajuda ou estiver pronto(a) para continuar, ficaremos felizes em atender você!</p>

            <!-- Botão para contato ou página de ajuda -->
            <a href="contato.php" class="btn btn-primary">Fale Conosco</a>

            <!-- Link para voltar à página inicial -->
            <a href="index.php" class="back-link">Voltar à página inicial</a>
        </div>
    </div>

    <!-- Bootstrap JS and dependencies -->
    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.9.2/dist/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
</body>
</html>
