<?php
session_start();
require 'config.php'; // Inclua sua configuração de banco de dados aqui

// Inicializa variáveis para mostrar erros
$errors = [];

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Captura os dados do formulário
    $usuario = $_POST['usuario'];
    $email = $_POST['email'];
    $cpf = $_POST['cpf'];
    $senha = $_POST['senha'];
    $confirmar_senha = $_POST['confirmar_senha'];

    // Valida os dados do formulário
    if (empty($usuario) || empty($email) || empty($cpf) || empty($senha) || empty($confirmar_senha)) {
        $errors[] = "Todos os campos devem ser preenchidos.";
    }

    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $errors[] = "Formatação de email inválida.";
    }

    if ($senha !== $confirmar_senha) {
        $errors[] = "As senhas não coincidem.";
    }

    // Verifica se o nome de usuário já existe no banco de dados
    $stmt = $conn->prepare("SELECT * FROM usuarios WHERE username = ?");
    $stmt->execute([$usuario]);
    if ($stmt->rowCount() > 0) {
        $errors[] = "O nome de usuário já está cadastrado.";
    }

    // Verifica se o email já existe no banco de dados
    $stmt = $conn->prepare("SELECT * FROM usuarios WHERE email = ?");
    $stmt->execute([$email]);
    if ($stmt->rowCount() > 0) {
        $errors[] = "O email já está cadastrado.";
    }

    // Verifica se o CPF já existe no banco de dados
    $stmt = $conn->prepare("SELECT * FROM usuarios WHERE cpf = ?");
    $stmt->execute([$cpf]);
    if ($stmt->rowCount() > 0) {
        $errors[] = "O CPF já está cadastrado.";
    }

    // Se não houver erros, insere o usuário no banco de dados
    if (empty($errors)) {
        $senha_hash = password_hash($senha, PASSWORD_DEFAULT); // Hash da senha
        $sql = "INSERT INTO usuarios (username, email, cpf, password) VALUES (?, ?, ?, ?)";
        $stmt = $conn->prepare($sql);
        if ($stmt->execute([$usuario, $email, $cpf, $senha_hash])) {
            // Cria o diretório para o usuário
            $user_id = $conn->lastInsertId();
            $userDirectory = 'restaurantes/' . $user_id;

            if (!file_exists($userDirectory)) {
                mkdir($userDirectory, 0755, true);
            }

            $_SESSION['user_id'] = $user_id;
            header("Location: dashboard.php");
            exit();
        } else {
            $errors[] = "Ocorreu um erro ao criar sua conta. Tente novamente.";
        }
    }
}
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Registro</title>
    <link href="css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            background-color: #f4f4f4;
        }
        .container {
            margin-top: 50px;
            max-width: 400px;
        }
        .error {
            color: red;
        }
    </style>
</head>
<body>
    <div class="container">
        <h2 class="text-center">Registro</h2>
        <?php if (!empty($errors)): ?>
            <div class="alert alert-danger">
                <?php foreach ($errors as $error): ?>
                    <p><?php echo $error; ?></p>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
        
        <form action="" method="POST">
            <div class="mb-3">
                <label for="usuario" class="form-label">Usuário</label>
                <input type="text" class="form-control" name="usuario" required>
            </div>
            <div class="mb-3">
                <label for="email" class="form-label">Email</label>
                <input type="email" class="form-control" name="email" required>
            </div>
            <div class="mb-3">
                <label for="cpf" class="form-label">CPF</label>
                <input type="text" class="form-control" name="cpf" required>
            </div>
            <div class="mb-3">
                <label for="senha" class="form-label">Senha</label>
                <input type="password" class="form-control" name="senha" required>
            </div>
            <div class="mb-3">
                <label for="confirmar_senha" class="form-label">Confirmar Senha</label>
                <input type="password" class="form-control" name="confirmar_senha" required>
            </div>
            <button type="submit" class="btn btn-primary">Registrar</button>
            <p class="mt-2">Já tem uma conta? <a href="login.php">Faça login</a></p>
        </form>
    </div>
    
    <script src="js/bootstrap.bundle.min.js"></script>
</body>
</html>